#ifndef STUPID_EXPERIMENTER_PLUGIN_H
#define STUPID_EXPERIMENTER_PLUGIN_H

#include "ExperimenterPlugin.h"
#include "DatabaseMessage.h"

// Don't remove this! Needed by maze simulator as hook to construct plugin.
extern "C" _EXPORT ExperimenterPlugin *instantiate_exp();

/*******************************************************
* Created: 7/29/00, CGP
* Modified: 9/15/00, CGP
* 	Enabled settings retrieval via BMessage returned in GetParameters call.
*******************************************************/

class StupidExperimenterPlugin : public ExperimenterPlugin {
   public:
   	  // Don't change this! Needed by maze simulator to check version compatibility!
      int PLUGIN_API_Version() {return EXPERIMENTER_API_VER;};
      
      // Call constructor to set up the environment for running a new rat.
      StupidExperimenterPlugin(PortMessage *expRatPort,
      	PortMessage *envExpPort, DatabaseMessage *dbMsg, UserEnvMessage *userEnvMsg,
      		DebugServer *bugServer);
      ~StupidExperimenterPlugin();

      // Redeclare & override virtual functions
      void PLUGIN_Setup();
      void PLUGIN_RunTrial();
      void PLUGIN_RatConsumedFood();
      void PLUGIN_RatMoved(BMessage *msg);

	private: // functions
	   bool FoodOnMaze(int numArms);
	   void OpenDoors(int numArms);
	   void BaitMaze(); // bait all maze arms
	   
	private: // data members-- available across calls to Setup, RunTrial, etc.
	   int numFood; // num peices of food current on maze
	   int16 ratNo;
	   int numArms; // on maze
};

#endif